/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.virtdata.core.templates.BindPoint;
import io.nosqlbench.virtdata.core.templates.BindPointParser;
import io.nosqlbench.virtdata.core.templates.CapturePoint;
import io.nosqlbench.virtdata.core.templates.CapturePointParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParsedTemplate {
    private static final Logger logger = LogManager.getLogger(ParsedTemplate.class);
    private final String rawtemplate;
    private final List<CapturePoint> captures;
    private final List<BindPoint> bindpoints;
    private final String[] spans;
    private final Map<String, String> bindings = new LinkedHashMap<String, String>();
    private final BindPointParser bindPointParser = new BindPointParser();
    private final CapturePointParser capturePointParser = new CapturePointParser();

    public static ParsedTemplate of(String rawtemplate, Map<String, String> bindings) {
        return new ParsedTemplate(rawtemplate, bindings);
    }

    public ParsedTemplate(String rawtemplate, Map<String, String> availableBindings) {
        this.bindings.putAll(availableBindings);
        this.rawtemplate = rawtemplate;
        CapturePointParser.Result captureData = this.capturePointParser.apply(rawtemplate);
        this.captures = captureData.getCaptures();
        BindPointParser.Result bindPointsResult = this.bindPointParser.apply(captureData.getRawTemplate(), availableBindings);
        this.spans = bindPointsResult.getSpans().toArray(new String[0]);
        this.bindpoints = bindPointsResult.getBindpoints();
    }

    public Type getType() {
        if (this.spans.length == 1) {
            return Type.literal;
        }
        if (this.spans[0].isEmpty() && this.spans[2].isEmpty()) {
            return Type.bindref;
        }
        return Type.concat;
    }

    public ParsedTemplate orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this);
        }
        return this;
    }

    public String toString() {
        String sb = "parsed: " + StreamSupport.stream(Arrays.spliterator(this.spans), false).map(s -> "[" + s + "]").collect(Collectors.joining(",")) + (String)(this.getMissing().size() > 0 ? "\n missing bindings: " + this.getMissing().stream().collect(Collectors.joining(",", "[", "]")) : "");
        return sb;
    }

    public boolean hasError() {
        return this.getMissing().size() > 0;
    }

    public Set<String> getMissing() {
        if (this.spans.length == 1) {
            return Set.of();
        }
        HashSet<String> missing = new HashSet<String>();
        for (int i = 1; i < this.spans.length; i += 2) {
            if (this.bindings.containsKey(this.spans[i])) continue;
            missing.add(this.spans[i]);
        }
        return missing;
    }

    public List<String> getAnchors() {
        ArrayList<String> anchors = new ArrayList<String>();
        for (int i = 1; i < this.spans.length; i += 2) {
            anchors.add(this.spans[i]);
        }
        return anchors;
    }

    public List<BindPoint> getBindPoints() {
        this.bindpoints.forEach(b -> {
            if (b.getBindspec() == null || b.getBindspec().isEmpty()) {
                throw new RuntimeException("No binding spec was provided for bind point '" + b + "'");
            }
        });
        return this.bindpoints;
    }

    public String getPositionalStatement(Function<String, String> tokenFormatter) {
        StringBuilder sb = new StringBuilder(this.spans[0]);
        for (int i = 1; i < this.spans.length; i += 2) {
            sb.append(tokenFormatter != null ? tokenFormatter.apply(this.spans[i]) : this.spans[i]);
            sb.append(this.spans[i + 1]);
        }
        return sb.toString();
    }

    public String[] getSpans() {
        return this.spans;
    }

    public Optional<BindPoint> asBinding() {
        if (this.spans.length == 3 && this.spans[0].isEmpty() && this.spans[2].isEmpty()) {
            return Optional.of(this.bindpoints.get(0));
        }
        return Optional.empty();
    }

    public List<CapturePoint> getCaptures() {
        return this.captures;
    }

    public String getStmt() {
        return this.rawtemplate;
    }

    public static enum Type {
        literal,
        bindref,
        concat;

    }
}

