/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.virtdata.core.bindings.Binder;
import io.nosqlbench.virtdata.core.bindings.Bindings;
import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import io.nosqlbench.virtdata.core.templates.StringCompositor;

public class StringBindings
implements Binder<String> {
    private final StringCompositor compositor;
    private final Bindings bindings;

    public StringBindings(StringCompositor compositor, Bindings bindings) {
        this.compositor = compositor;
        this.bindings = bindings;
    }

    public StringBindings(ParsedTemplate pt) {
        this.compositor = new StringCompositor(pt);
        this.bindings = new BindingsTemplate(pt.getBindPoints()).resolveBindings();
    }

    @Override
    public String bind(long value) {
        String s = this.compositor.bindValues(this.compositor, this.bindings, value);
        return s;
    }

    public String toString() {
        return "StringBindings{compositor=" + this.compositor + ", bindings=" + this.bindings + "}";
    }
}

