/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.virtdata.core.bindings.Bindings;
import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.templates.StringBindings;
import io.nosqlbench.virtdata.core.templates.StringCompositor;
import java.util.HashSet;

public class StringBindingsTemplate {
    private final String stringTemplate;
    private final BindingsTemplate bindingsTemplate;

    public StringBindingsTemplate(String stringTemplate, BindingsTemplate bindingsTemplate) {
        this.stringTemplate = stringTemplate;
        this.bindingsTemplate = bindingsTemplate;
    }

    public StringBindings resolve() {
        StringCompositor compositor = new StringCompositor(this.stringTemplate);
        HashSet<String> unqualifiedNames = new HashSet<String>(compositor.getBindPointNames());
        unqualifiedNames.removeAll(new HashSet<String>(this.bindingsTemplate.getBindPointNames()));
        if (unqualifiedNames.size() > 0) {
            throw new RuntimeException("Named anchors were specified in the template which were not provided in the bindings: " + unqualifiedNames);
        }
        Bindings bindings = this.bindingsTemplate.resolveBindings();
        return new StringBindings(compositor, bindings);
    }

    public String getDiagnostics() {
        StringCompositor compositor = new StringCompositor(this.stringTemplate);
        HashSet<String> unqualifiedNames = new HashSet<String>(compositor.getBindPointNames());
        unqualifiedNames.removeAll(new HashSet<String>(this.bindingsTemplate.getBindPointNames()));
        if (unqualifiedNames.size() > 0) {
            throw new RuntimeException("Named anchors were specified in the template which were not provided in the bindings: " + unqualifiedNames);
        }
        return this.bindingsTemplate.getDiagnostics();
    }

    public String toString() {
        return "TEMPLATE:" + this.stringTemplate + " BINDING:" + this.bindingsTemplate.toString();
    }
}

