/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.core.templates;

import io.nosqlbench.virtdata.core.bindings.Bindings;
import io.nosqlbench.virtdata.core.bindings.ValuesBinder;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class StringCompositor
implements ValuesBinder<StringCompositor, String> {
    private final String[] templateSegments;
    private Function<Object, String> stringfunc = String::valueOf;

    public StringCompositor(String template) {
        this.templateSegments = this.parseTemplate(template);
    }

    public StringCompositor(String template, Function<Object, String> stringfunc) {
        this(template);
        this.stringfunc = stringfunc;
    }

    public StringCompositor(ParsedTemplate pt) {
        this.templateSegments = pt.getSpans();
    }

    protected String[] parseTemplate(String template) {
        ParsedTemplate parsed = new ParsedTemplate(template, Collections.emptyMap());
        return parsed.getSpans();
    }

    @Override
    public String bindValues(StringCompositor context, Bindings bindings, long cycle) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 == 0) {
                sb.append(this.templateSegments[i]);
                continue;
            }
            String key = this.templateSegments[i];
            Object value = bindings.get(key, cycle);
            String valueString = this.stringfunc.apply(value);
            sb.append(valueString);
        }
        return sb.toString();
    }

    public List<String> getBindPointNames() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 != 1) continue;
            tokens.add(this.templateSegments[i]);
        }
        return tokens;
    }
}

