/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.lang.parser;

import io.nosqlbench.virtdata.lang.ast.VirtDataAST;
import io.nosqlbench.virtdata.lang.ast.VirtDataFlow;
import io.nosqlbench.virtdata.lang.generated.VirtDataLexer;
import io.nosqlbench.virtdata.lang.generated.VirtDataParser;
import io.nosqlbench.virtdata.lang.parser.VirtDataBuilder;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtDataDSL {
    private static final Logger logger = LogManager.getLogger(VirtDataDSL.class);

    public static ParseResult parse(String input) {
        try {
            VirtDataAST ast;
            List<VirtDataFlow> flows;
            CodePointCharStream cstream = CharStreams.fromString((String)input);
            VirtDataLexer lexer = new VirtDataLexer((CharStream)cstream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            VirtDataParser parser = new VirtDataParser((TokenStream)tokens);
            VirtDataBuilder astListener = new VirtDataBuilder();
            parser.addParseListener(astListener);
            VirtDataParser.VirtdataFlowContext virtdataFlowContext = parser.virtdataFlow();
            logger.trace("parse tree: " + virtdataFlowContext.toStringTree(parser));
            if (astListener.hasErrors()) {
                System.out.println(astListener.getErrorNodes());
            }
            if ((flows = (ast = astListener.getModel()).getFlows()).size() > 1) {
                throw new RuntimeException("Only one flow expected here.");
            }
            if (astListener.hasErrors()) {
                throw new RuntimeException("Error parsing input '" + input + "'");
            }
            return new ParseResult(flows.get(0));
        }
        catch (Exception e) {
            logger.warn("Error while parsing flow:" + e.getMessage());
            return new ParseResult(e);
        }
    }

    public static class ParseResult {
        public Throwable throwable;
        public VirtDataFlow flow;

        public ParseResult(VirtDataFlow flow) {
            this.flow = flow;
        }

        public ParseResult(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

