/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.AliasSamplerDoubleInt;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.EvProbD;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.math3.stat.Frequency;

@Categories(value={Category.general})
@ThreadSafeMapper
public class CSVFrequencySampler
implements LongFunction<String> {
    private final String[] lines;
    private final AliasSamplerDoubleInt sampler;
    private final Hash hash;

    @Example(value={"CSVFrequencySampler('values.csv','modelno')", "Read values.csv, count the frequency of values in 'modelno' column, and sample from this column proportionally"})
    public CSVFrequencySampler(String filename, String columnName) {
        String filename1 = filename;
        this.hash = new Hash();
        HashSet<String> values = new HashSet<String>();
        ArrayList<EvProbD> frequencies = new ArrayList<EvProbD>();
        if (!((String)filename).endsWith(".csv")) {
            filename = (String)filename + ".csv";
        }
        CSVParser csvdata = NBIO.readFileCSV((String)filename, (String[])new String[0]);
        Frequency freq = new Frequency();
        for (CSVRecord csvdatum : csvdata) {
            if (csvdatum.get(columnName) == null) continue;
            String value = csvdatum.get(columnName);
            freq.addValue((Comparable)((Object)value));
            values.add(value);
        }
        int i = 0;
        for (String value : values) {
            frequencies.add(new EvProbD(i++, freq.getCount((Comparable)((Object)value))));
        }
        this.sampler = new AliasSamplerDoubleInt(frequencies);
        this.lines = values.toArray(new String[0]);
    }

    @Override
    public String apply(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unitValue = (double)value / 9.223372036854776E18;
        int idx = this.sampler.applyAsInt(unitValue);
        return this.lines[idx];
    }
}

