/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class, selector="io.nosqlbench.virtdata.library.basics.shared.distributions.CSVFrequencySampler")
public class CSVFrequencySamplerAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "CSVFrequencySampler";
    }

    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.distributions";
    }

    public String getClassJavadoc() {
        return "Takes a CSV with sample data and generates random values based on the\nrelative frequencies of the values in the file.\nThe CSV file must have headers which can\nbe used to find the named columns.\n\nI.E. take the following imaginary `animals.csv` file:\nanimal,count,country\npuppy,1,usa\npuppy,2,colombia\npuppy,3,senegal\nkitten,2,colombia\n\n`CSVFrequencySampler('animals.csv', animal)` will return `puppy` or `kitten` randomly. `puppy` will be 3x more frequent than `kitten`.\n\n`CSVFrequencySampler('animals.csv', country)` will return `usa`, `colombia`, or `senegal` randomly. `colombia` will be 2x more frequent than `usa` or `senegal`.\n\nUse this function to infer frequencies of categorical values from CSVs.\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.lang.String";
    }

    public Category[] getCategories() {
        return new Category[]{Category.general};
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("CSVFrequencySampler", "Create a sampler of strings from the given CSV file. The CSV file must have plain CSV headers\nas its first line.\n@param filename The name of the file to be read into the sampler buffer\n@param columnName The name of the column to be sampled\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("filename", "java.lang.String");
                        this.put("columnName", "java.lang.String");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("CSVFrequencySampler('values.csv','modelno')");
                                this.add("Read values.csv, count the frequency of values in 'modelno' column, and sample from this column proportionally");
                            }
                        });
                    }
                }));
            }
        };
    }
}

