/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.AliasElementSampler;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.ElemProbD;
import io.nosqlbench.virtdata.library.basics.shared.distributions.LabeledStatistic;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@Categories(value={Category.general})
@ThreadSafeMapper
public class CSVSampler
implements LongFunction<String> {
    private final AliasElementSampler<String> sampler;
    private final LongUnaryOperator prefunc;
    private static final Set MODES = Set.of("map", "hash", "sum", "avg", "count", "min", "name", "max");

    /*
     * WARNING - void declaration
     */
    @Example(value={"CSVSampler('USPS','n/a','name','census_state_abbrev')", ""})
    public CSVSampler(String labelColumn, String weightColumn, String ... data) {
        Function<LabeledStatistic, Double> weightFunc = LabeledStatistic::sum;
        LongUnaryOperator prefunc = new Hash();
        boolean weightRequired = false;
        block20: while (data.length > 0 && MODES.contains(data[0])) {
            String cfg = data[0];
            data = Arrays.copyOfRange(data, 1, data.length);
            switch (cfg) {
                case "map": {
                    prefunc = i -> i;
                    continue block20;
                }
                case "hash": {
                    prefunc = new Hash();
                    continue block20;
                }
                case "sum": {
                    weightFunc = LabeledStatistic::sum;
                    weightRequired = true;
                    continue block20;
                }
                case "min": {
                    weightFunc = LabeledStatistic::min;
                    weightRequired = true;
                    continue block20;
                }
                case "max": {
                    weightFunc = LabeledStatistic::max;
                    weightRequired = true;
                    continue block20;
                }
                case "avg": {
                    weightFunc = LabeledStatistic::avg;
                    weightRequired = true;
                    continue block20;
                }
                case "count": {
                    weightFunc = LabeledStatistic::count;
                    weightRequired = false;
                    continue block20;
                }
                case "name": {
                    weightFunc = v -> 1.0;
                    weightRequired = false;
                    continue block20;
                }
            }
            throw new BasicError("Unknown cfg verb '" + cfg + "'");
        }
        this.prefunc = prefunc;
        Function<LabeledStatistic, Double> valFunc = weightFunc;
        HashMap<String, LabeledStatistic> entries = new HashMap<String, LabeledStatistic>();
        for (String string : data) {
            void var12_13;
            if (!string.endsWith(".csv")) {
                String string2 = string + ".csv";
            }
            CSVParser csvdata = NBIO.readFileCSV((String)var12_13, (String[])new String[0]);
            String labelName = csvdata.getHeaderNames().stream().filter(labelColumn::equalsIgnoreCase).findAny().orElseThrow();
            String weightName = "none";
            if (weightRequired) {
                weightName = csvdata.getHeaderNames().stream().filter(weightColumn::equalsIgnoreCase).findAny().orElseThrow();
            }
            double weight = 1.0;
            for (CSVRecord csvdatum : csvdata) {
                if (csvdatum.get(labelName) == null) continue;
                String label = csvdatum.get(labelName);
                if (weightRequired) {
                    String weightString = csvdatum.get(weightName);
                    weight = weightString.isEmpty() ? 1.0 : Double.parseDouble(weightString);
                }
                LabeledStatistic entry = new LabeledStatistic(label, weight);
                entries.merge(label, entry, LabeledStatistic::merge);
            }
        }
        List elemList = entries.values().stream().map(t -> new ElemProbD<String>(t.label, (Double)valFunc.apply((LabeledStatistic)t))).collect(Collectors.toList());
        this.sampler = new AliasElementSampler(elemList);
    }

    @Override
    public String apply(long value) {
        value = this.prefunc.applyAsLong(value);
        double unitValue = (double)value / 9.223372036854776E18;
        String val = this.sampler.apply(unitValue);
        return val;
    }
}

