/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class, selector="io.nosqlbench.virtdata.library.basics.shared.distributions.CSVSampler")
public class CSVSamplerAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "CSVSampler";
    }

    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.distributions";
    }

    public String getClassJavadoc() {
        return "\nThis function is a toolkit version of the {@link WeightedStringsFromCSV} function.\nIt is more capable and should be the preferred function for alias sampling over any CSV data.\nThis sampler uses a named column in the CSV data as the value. This is also referred to as the\n<em>labelColumn</em>. The frequency of this label depends on the weight assigned to it in another named\nCSV column, known as the <em>weightColumn</em>.\n\n<H3>Combining duplicate labels</H3>\nWhen you have CSV data which is not organized around the specific identifier that you want to sample by,\nyou can use some combining functions to tabulate these prior to sampling. In that case, you can use\nany of \"sum\", \"avg\", \"count\", \"min\", or \"max\" as the reducing function on the value in the weight column.\nIf none are specified, then \"sum\" is used by default. All modes except \"count\" and \"name\" require a valid weight\ncolumn to be specified.\n\n<UL>\n    <LI>sum, avg, min, max - takes the given stat for the weight of each distinct label</LI>\n    <LI>count - takes the number of occurrences of a given label as the weight</LI>\n    <LI>name - sets the weight of all distinct labels to 1.0d</LI>\n</UL>\n\n<H3>Map vs Hash mode</H3>\nAs with some of the other statistical functions, you can use this one to pick through the sample values\nby using the <em>map</em> mode. This is distinct from the default <em>hash</em> mode. When map mode is used,\nthe values will appear monotonically as you scan through the unit interval of all long values.\nSpecifically, 0L represents 0.0d in the unit interval on input, and Long.MAX_VALUE represents\n1.0 on the unit interval.) This mode is only recommended for advanced scenarios and should otherwise be\navoided. You will know if you need this mode.\n\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.lang.String";
    }

    public Category[] getCategories() {
        return new Category[]{Category.general};
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("CSVSampler", "Build an efficient O(1) sampler for the given column values with respect to the weights,\ncombining equal values by summing the weights.\n\n@param labelColumn   The CSV column name containing the value\n@param weightColumn  The CSV column name containing a double weight\n@param data Sampling modes or file names. Any of map, hash, sum, avg, count are taken\n            as configuration modes, and all others are taken as CSV filenames.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("labelColumn", "java.lang.String");
                        this.put("weightColumn", "java.lang.String");
                        this.put("data", "java.lang.String[]...");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("CSVSampler('USPS','n/a','name','census_state_abbrev')");
                                this.add("");
                            }
                        });
                    }
                }));
            }
        };
    }
}

