/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigdecimal;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.math.BigDecimal;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ModuloToBigDecimal
implements LongFunction<BigDecimal> {
    private static final Logger logger = LogManager.getLogger(ModuloToBigDecimal.class);
    private final long modulo;

    public ModuloToBigDecimal() {
        this.modulo = Long.MAX_VALUE;
    }

    public ModuloToBigDecimal(long modulo) {
        this.modulo = modulo;
    }

    @Override
    public BigDecimal apply(long value) {
        long ret = value % this.modulo & Long.MAX_VALUE;
        return BigDecimal.valueOf(ret);
    }
}

