/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigdecimal;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.util.MathContextReader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToBigDecimal
implements LongFunction<BigDecimal> {
    private final MathContext mathContext;
    private final int scale;

    @Example(value={"ToBigDecimal()", "Convert all long values to whole-numbered BigDecimal values"})
    public ToBigDecimal() {
        this(0);
    }

    @Examples(value={@Example(value={"ToBigDecimal(0)", "Convert all long values to whole-numbered BigDecimal values"}), @Example(value={"ToBigDecimal(2)", "Convert long 'pennies' BigDecimal with 2 digits after decimal point"})})
    public ToBigDecimal(int scale) {
        this.scale = scale;
        this.mathContext = null;
    }

    @Examples(value={@Example(value={"ToBigDecimal('DECIMAL32')", "IEEE 754R Decimal32 format, 7 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('DECIMAL64'),", "IEEE 754R Decimal64 format, 16 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('DECIMAL128')", "IEEE 754R Decimal128 format, 34 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('UNLIMITED')", "unlimited precision, HALF_UP"}), @Example(value={"ToBigDecimal('precision=17 roundingMode=UNNECESSARY')", "Custom precision with no rounding performed"})})
    public ToBigDecimal(String context) {
        this.scale = Integer.MIN_VALUE;
        this.mathContext = MathContextReader.getMathContext(context);
    }

    @Override
    public BigDecimal apply(long value) {
        if (this.mathContext != null) {
            return new BigDecimal(value, this.mathContext);
        }
        return BigDecimal.valueOf(value, this.scale);
    }
}

