/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigdecimal;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class, selector="io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigdecimal.ToBigDecimal")
public class ToBigDecimalAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "ToBigDecimal";
    }

    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_bigdecimal";
    }

    public String getClassJavadoc() {
        return "Convert values to BigDecimals at configurable scale or precision.\n\n<p>\nToBigDecimal(...) functions which take whole-numbered inputs may have\na scale parameter or a custom MathContext, but not both. The scale parameter\nis not supported for String or Double input forms.\n</p>\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.math.BigDecimal";
    }

    public Category[] getCategories() {
        return new Category[]{Category.conversion};
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("ToBigDecimal", "", (Map)new LinkedHashMap<String, String>(){}, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal()");
                                this.add("Convert all long values to whole-numbered BigDecimal values");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToBigDecimal", "", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("scale", "int");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal(0)");
                                this.add("Convert all long values to whole-numbered BigDecimal values");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal(2)");
                                this.add("Convert long 'pennies' BigDecimal with 2 digits after decimal point");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("ToBigDecimal", "Convert all input values to BigDecimal values with a specific MathContext. This form is only\nsupported for scale=0, meaning whole numbers. The value for context can be one of UNLIMITED,\nDECIMAL32, DECIMAL64, DECIMAL128, or any valid configuration supported by\n{@link MathContext#MathContext(String)}, such as {@code \"precision=32 roundingMode=CEILING\"}.\nIn the latter form, roundingMode can be any valid value for {@link RoundingMode}, like\nUP, DOWN, CEILING, FLOOR, HALF_UP, HALF_DOWN, HALF_EVEN, or UNNECESSARY.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("context", "java.lang.String");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal('DECIMAL32')");
                                this.add("IEEE 754R Decimal32 format, 7 digits, HALF_EVEN");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal('DECIMAL64'),");
                                this.add("IEEE 754R Decimal64 format, 16 digits, HALF_EVEN");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal('DECIMAL128')");
                                this.add("IEEE 754R Decimal128 format, 34 digits, HALF_EVEN");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal('UNLIMITED')");
                                this.add("unlimited precision, HALF_UP");
                            }
                        });
                        this.add(new ArrayList<String>(){
                            {
                                this.add("ToBigDecimal('precision=17 roundingMode=UNNECESSARY')");
                                this.add("Custom precision with no rounding performed");
                            }
                        });
                    }
                }));
            }
        };
    }
}

