/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bytebuffer;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.conversion, Category.general})
@ThreadSafeMapper
public class ByteBufferSizedHashed
implements LongFunction<ByteBuffer> {
    private final LongToIntFunction sizeFunc;
    private final Hash hash = new Hash();

    @Examples(value={@Example(value={"ByteBufferSizedHashed(16)", "Functionally identical to HashedtoByteBuffer(16) but using dynamic sizing implementation"}), @Example(value={"ByteBufferSizedHashed(HashRange(10, 14))", "Create a ByteBuffer with variable limit (10 to 14)"})})
    public ByteBufferSizedHashed(int size) {
        this.sizeFunc = s -> size;
    }

    public ByteBufferSizedHashed(Object sizeFunc) {
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizeFunc = s -> size;
        } else {
            this.sizeFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
    }

    @Override
    public ByteBuffer apply(long input) {
        int length = this.sizeFunc.applyAsInt(input);
        int longs = length / 8 + 1;
        int bytes = longs * 8;
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        for (int i = 0; i < longs; ++i) {
            long l = this.hash.applyAsLong(input + (long)i);
            buffer.putLong(l);
        }
        buffer.flip();
        buffer.limit(length);
        return buffer;
    }
}

