/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bytebuffer;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_bytebuffer.ByteBufferSizedHashed;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.Hash;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class HashedByteBufferExtract
implements LongFunction<ByteBuffer> {
    private final LongToIntFunction sizefunc;
    private final ThreadLocal<ByteBuffer> bbaccessor;
    private final Hash inthash = new Hash();

    public HashedByteBufferExtract(Object initFunc, Object sizeFunc) {
        ByteBuffer image = null;
        if (initFunc instanceof Number) {
            int bufsize = ((Number)initFunc).intValue();
            ByteBufferSizedHashed bufgen = new ByteBufferSizedHashed(bufsize);
            image = bufgen.apply(0L).asReadOnlyBuffer();
        } else {
            LongFunction bbfunc = (LongFunction)VirtDataConversions.adaptFunction((Object)initFunc, LongFunction.class, (Class[])new Class[]{ByteBuffer.class});
            image = ((ByteBuffer)bbfunc.apply(0L)).asReadOnlyBuffer();
        }
        ByteBuffer finalImage = image;
        this.bbaccessor = ThreadLocal.withInitial(() -> finalImage.asReadOnlyBuffer());
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizefunc = l -> size;
        } else {
            this.sizefunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
    }

    @Override
    public ByteBuffer apply(long value) {
        ByteBuffer bbimage = this.bbaccessor.get();
        int newbufsize = this.sizefunc.applyAsInt(value);
        newbufsize = Math.min(newbufsize, bbimage.capacity());
        byte[] bytes = new byte[newbufsize];
        int base_offset = this.inthash.applyAsInt(value) % (bbimage.capacity() - bytes.length);
        this.bbaccessor.get().position(base_offset).get(bytes);
        return ByteBuffer.wrap(bytes);
    }
}

