/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_charbuffer;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.Hash;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_string.CharBufImage;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class CharBufferExtract
implements LongFunction<CharBuffer> {
    private final CharBuffer image;
    private final LongToIntFunction sizefunc;
    private final Hash posFunc = new Hash();
    private final int imgsize;

    public CharBufferExtract(Object initFunc, Object sizeFunc) {
        Object image = null;
        if (initFunc instanceof Number) {
            int bufsize = ((Number)initFunc).intValue();
            this.image = new CharBufImage(bufsize).apply(1L);
        } else {
            LongFunction bbfunc = (LongFunction)VirtDataConversions.adaptFunction((Object)initFunc, LongFunction.class, (Class[])new Class[]{String.class});
            this.image = CharBuffer.wrap((CharSequence)bbfunc.apply(0L));
        }
        this.imgsize = this.image.limit();
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizefunc = l -> size;
        } else {
            this.sizefunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
    }

    @Override
    public CharBuffer apply(long value) {
        int size = Math.min(this.sizefunc.applyAsInt(value), this.imgsize);
        int pos = this.posFunc.applyAsInt(value);
        return this.image.subSequence(pos %= this.imgsize - size + 1, pos + size);
    }
}

