/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.HashRange;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.collections})
public class HashedRangeToLongList
implements LongFunction<List<Long>> {
    private final HashRange valueRange;
    private final HashRange sizeRange;

    public HashedRangeToLongList(int minVal, int maxVal, int minSize, int maxSize) {
        if (minSize >= maxSize || minSize >= maxSize) {
            throw new RuntimeException("HashedRangeToLongList must have minval, maxval, minsize, maxsize, where min<max.");
        }
        this.valueRange = new HashRange(minVal, maxVal);
        this.sizeRange = new HashRange(minSize, maxSize);
    }

    @Override
    public List<Long> apply(long value) {
        long listSize = this.sizeRange.applyAsLong(value);
        ArrayList<Long> longList = new ArrayList<Long>();
        int i = 0;
        while ((long)i < listSize) {
            longList.add(this.valueRange.applyAsLong(value + (long)i));
            ++i;
        }
        return longList;
    }
}

