/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class ListStepped
implements LongFunction<List<Object>> {
    private final List<LongFunction> valueFuncs;
    private final int size;

    @Example(value={"ListStepped(NumberNameToString(),NumberNameToString())", "Create a list of ['one','two']"})
    public ListStepped(Object ... funcs) {
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
        this.size = this.valueFuncs.size();
    }

    @Override
    public List<Object> apply(long value) {
        ArrayList<Object> list = new ArrayList<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction func = this.valueFuncs.get(selector);
            list.add(func.apply(value + (long)i));
        }
        return list;
    }
}

