/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class MapFunctions
implements LongFunction<Map<Object, Object>> {
    private final List<LongFunction> valueFuncs;
    private final List<LongFunction> keyFuncs;
    private final int size;

    @Example(value={"MapFunctions(NumberNameToString(),NumberNameToString(),ToString(),ToString())", "Create a map of object values. Produces values like {'one':'one'1:1}."})
    public MapFunctions(Object ... funcs) {
        this.keyFuncs = VirtDataConversions.getFunctions((int)2, (int)0, LongFunction.class, (Object[])funcs);
        this.valueFuncs = VirtDataConversions.getFunctions((int)2, (int)1, LongFunction.class, (Object[])funcs);
        this.size = this.valueFuncs.size();
    }

    @Override
    public Map<Object, Object> apply(long value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object keyObject = this.keyFuncs.get(i).apply(value);
            Object valueObject = this.valueFuncs.get(i).apply(value);
            map.put(keyObject, valueObject);
        }
        return map;
    }
}

