/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class MapSized
implements LongFunction<Map<Object, Object>> {
    private final List<LongFunction> valueFuncs;
    private final List<LongFunction> keyFuncs;
    private final LongToIntFunction sizeFunc;

    @Example(value={"MapSized(1, NumberNameToString(),NumberNameToString(),ToString(),ToString())", "Create a map of object values. Produces values like {'one':'one'1:1}."})
    public MapSized(Object sizeFunc, Object ... funcs) {
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizeFunc = s -> size;
        } else {
            this.sizeFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
        this.keyFuncs = VirtDataConversions.getFunctions((int)2, (int)0, LongFunction.class, (Object[])funcs);
        this.valueFuncs = VirtDataConversions.getFunctions((int)2, (int)1, LongFunction.class, (Object[])funcs);
    }

    public MapSized(int size, Object ... funcs) {
        this.sizeFunc = s -> size;
        this.keyFuncs = VirtDataConversions.getFunctions((int)2, (int)0, LongFunction.class, (Object[])funcs);
        this.valueFuncs = VirtDataConversions.getFunctions((int)2, (int)1, LongFunction.class, (Object[])funcs);
    }

    @Override
    public Map<Object, Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            int keySelector = Math.min(i, this.keyFuncs.size() - 1);
            int valSelector = Math.min(i, this.valueFuncs.size() - 1);
            Object keyObject = this.keyFuncs.get(keySelector).apply(value);
            Object valueObject = this.valueFuncs.get(valSelector).apply(value);
            map.put(keyObject, valueObject);
        }
        return map;
    }
}

