/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.HashSet;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.collections})
@ThreadSafeMapper
@Deprecated
@DeprecatedFunction(value="use MapFunctions and related functions instead")
public class Set
implements LongFunction<java.util.Set<Object>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"Set(HashRange(3,7),Add(15L))", "create a set between 3 and 7 elements of Long values"})
    public Set(LongToIntFunction sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc;
    }

    public Set(LongToIntFunction sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc::applyAsLong;
    }

    public Set(LongToIntFunction sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc::applyAsInt;
    }

    public Set(LongFunction<Object> sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = Set.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc;
    }

    public Set(LongFunction<Object> sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = Set.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc::applyAsLong;
    }

    public Set(LongFunction<Object> sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = Set.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc::applyAsInt;
    }

    public Set(LongUnaryOperator sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc;
    }

    public Set(LongUnaryOperator sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc::applyAsLong;
    }

    public Set(LongUnaryOperator sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc::applyAsInt;
    }

    private static LongToIntFunction checkSizeFunc(LongFunction<?> sizeFunc) {
        Object sizeType = sizeFunc.apply(0L);
        if (Integer.TYPE.isAssignableFrom(sizeType.getClass())) {
            return value -> (Integer)sizeFunc.apply(value);
        }
        if (Long.TYPE.isAssignableFrom(sizeType.getClass())) {
            return value -> ((Long)sizeFunc.apply(value)).intValue();
        }
        throw new BasicError("The size function produces " + sizeType.getClass().getCanonicalName() + ", which can't be used as an integer");
    }

    @Override
    public java.util.Set<Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.valueFunc.apply(value + (long)i));
        }
        return set;
    }
}

