/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class SetSizedHashed
implements LongFunction<Set<Object>> {
    private final List<LongFunction> valueFuncs;
    private final Hash hasher = new Hash();
    private final LongToIntFunction sizeFunc;

    @Example(value={"SetSizedHashed(FixedValue(5),long->ToString(),long->WeightedStrings('text:1'),long->ToString())", "Create a sized set of values like ['2945182322382062539', 'text', '37945690212757860', '287864597160630738', '3299224200079606887']"})
    public SetSizedHashed(Object sizeFunc, Object ... funcs) {
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizeFunc = s -> size;
        } else {
            this.sizeFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
    }

    public SetSizedHashed(int size, Object ... funcs) {
        this.sizeFunc = s -> size;
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public Set<Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        long hashed = value;
        HashSet<Object> list = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            hashed = this.hasher.applyAsLong(hashed);
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction func = this.valueFuncs.get(selector);
            list.add(func.apply(hashed));
        }
        return list;
    }
}

