/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringSet
implements LongFunction<Set<String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"StringSet(HashRange(3,7),Add(15L))", "create a set between 3 and 7 elements of String representations of Long values"})
    public StringSet(LongToIntFunction sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc;
    }

    public StringSet(LongToIntFunction sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc::applyAsLong;
    }

    public StringSet(LongToIntFunction sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc::applyAsInt;
    }

    public StringSet(LongFunction<?> sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = StringSet.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc;
    }

    public StringSet(LongFunction<?> sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = StringSet.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc::applyAsLong;
    }

    public StringSet(LongFunction<?> sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = StringSet.checkSizeFunc(sizeFunc);
        this.valueFunc = valueFunc::applyAsInt;
    }

    public StringSet(LongUnaryOperator sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc;
    }

    public StringSet(LongUnaryOperator sizeFunc, LongUnaryOperator valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc::applyAsLong;
    }

    public StringSet(LongUnaryOperator sizeFunc, LongToIntFunction valueFunc) {
        this.sizeFunc = l -> (int)sizeFunc.applyAsLong(l);
        this.valueFunc = valueFunc::applyAsInt;
    }

    private static LongToIntFunction checkSizeFunc(LongFunction<?> sizeFunc) {
        Object sizeType = sizeFunc.apply(0L);
        if (Integer.TYPE.isAssignableFrom(sizeType.getClass())) {
            return value -> (Integer)sizeFunc.apply(value);
        }
        if (Long.TYPE.isAssignableFrom(sizeType.getClass())) {
            return value -> ((Long)sizeFunc.apply(value)).intValue();
        }
        throw new BasicError("The size function produces " + sizeType.getClass().getCanonicalName() + ", which can't be used as an integer");
    }

    @Override
    public Set<String> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashSet<String> set = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.valueFunc.apply(value + (long)i).toString());
        }
        return set;
    }
}

