/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_double;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class Interpolate
implements LongToDoubleFunction {
    private final double resolution;
    private final double[] lut;
    private final double scaleToLongInterval;

    @Examples(value={@Example(value={"Interpolate(0.0d,100.0d)", "return a uniform double value between 0.0d and 100.0d"}), @Example(value={"Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)", "return a weighted double value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D"})})
    public Interpolate(double ... values) {
        this.resolution = values.length;
        double[] doubles = new double[values.length + 1];
        System.arraycopy(values, 0, doubles, 0, values.length);
        doubles[doubles.length - 1] = doubles[doubles.length - 2];
        this.lut = doubles;
        this.scaleToLongInterval = (this.resolution - 1.0) * 1.0842021724855044E-19;
    }

    @Override
    public double applyAsDouble(long input) {
        double samplePoint = this.scaleToLongInterval * (double)input;
        int leftidx = (int)samplePoint;
        double fractional = samplePoint - (double)leftidx;
        double sample = this.lut[leftidx] * (1.0 - fractional) + this.lut[leftidx + 1] * fractional;
        return sample;
    }
}

