/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_inetaddress;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToInetAddress
implements LongFunction<InetAddress> {
    @Override
    public InetAddress apply(long input) {
        int image = (int)input % Integer.MAX_VALUE;
        ByteBuffer bytes = ByteBuffer.allocate(4);
        bytes.putInt(image);
        bytes.flip();
        try {
            return Inet4Address.getByAddress(bytes.array());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

