/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_int;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class CycleRange
implements LongToIntFunction {
    private final long minValue;
    private final long width;

    public CycleRange(int maxValue) {
        this(0, maxValue);
    }

    public CycleRange(int minValue, int maxValue) {
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new RuntimeException("CycleRange must have min and max value in that order.");
        }
        this.width = maxValue - minValue;
    }

    @Override
    public int applyAsInt(long operand) {
        return (int)(this.minValue + operand % this.width & Integer.MAX_VALUE);
    }
}

