/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_int;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.Hash;
import java.util.List;
import java.util.function.LongToIntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.general})
public class HashedLineToInt
implements LongToIntFunction {
    private static final Logger logger = LogManager.getLogger(HashedLineToInt.class);
    private final int[] values;
    private final String filename;
    private final Hash intHash;

    public HashedLineToInt(String filename) {
        this.filename = filename;
        List lines = NBIO.readLines((String)filename);
        this.values = lines.stream().mapToInt(Integer::parseInt).toArray();
        this.intHash = new Hash();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public int applyAsInt(long value) {
        int itemIdx = this.intHash.applyAsInt(value) % this.values.length;
        return this.values[itemIdx];
    }
}

