/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.murmur.Murmur3F;
import java.nio.ByteBuffer;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.general})
public class FullHash
implements LongUnaryOperator {
    private final ThreadLocal<State> state_TL = ThreadLocal.withInitial(() -> new State());

    @Override
    public long applyAsLong(long value) {
        State state = this.state_TL.get();
        state.murmur3F.reset();
        state.bb.putLong(0, value);
        state.murmur3F.update(state.bb.array(), 0, 8);
        return state.murmur3F.getValue();
    }

    private static class State {
        ByteBuffer bb = ByteBuffer.allocate(8);
        Murmur3F murmur3F = new Murmur3F();

        private State() {
        }
    }
}

