/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class HashRangeScaled
implements LongUnaryOperator {
    private final double scalefactor;
    private final Hash hash = new Hash();

    public HashRangeScaled(double scalefactor) {
        this.scalefactor = scalefactor;
    }

    public HashRangeScaled() {
        this.scalefactor = 1.0;
    }

    @Override
    public long applyAsLong(long operand) {
        if (operand == 0L) {
            return 0L;
        }
        long hashed = this.hash.applyAsLong(operand);
        return (long)((double)(hashed % operand) * this.scalefactor);
    }
}

