/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.murmur.Murmur3F;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.LongUnaryOperator;

public class HostHash
implements LongUnaryOperator {
    private static final long hostHash = HostHash.computeHostHash();
    private final ByteBuffer bb = ByteBuffer.allocate(8);
    private Murmur3F murmur3F = new Murmur3F((int)hostHash % Integer.MAX_VALUE);

    @Example(value={"HostHash()", "a simple per-host hash function"})
    public HostHash() {
    }

    @Example(value={"HostHash(2343)", "further permute the host hash with a specific seed"})
    public HostHash(int seedMod) {
        this.murmur3F.update(seedMod);
        this.murmur3F = new Murmur3F((int)this.murmur3F.getValue() & Integer.MAX_VALUE);
    }

    private static long computeHostHash() {
        try {
            HashSet<String> distinctNames = new HashSet<String>();
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface ni = nets.nextElement();
                distinctNames.add(ni.getDisplayName());
                distinctNames.add(ni.getName());
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    distinctNames.add(inetAddress.getHostName());
                    distinctNames.add(inetAddress.getHostAddress());
                }
            }
            InetAddress[] ifaces = InetAddress.getAllByName(null);
            Arrays.stream(ifaces).forEach(iface -> {
                distinctNames.add(iface.getCanonicalHostName());
                distinctNames.add(iface.getHostAddress());
                distinctNames.add(iface.getHostName());
            });
            ArrayList nameList = new ArrayList(distinctNames);
            Collections.sort(nameList);
            Murmur3F m3f = new Murmur3F(0);
            m3f.reset();
            nameList.forEach(s -> m3f.update(s.getBytes(StandardCharsets.UTF_8)));
            return m3f.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long applyAsLong(long value) {
        this.murmur3F.reset();
        this.bb.putLong(0, value);
        this.murmur3F.update(this.bb.array(), 0, 8);
        long result = Math.abs(this.murmur3F.getValue());
        return result;
    }
}

