/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.murmur.Murmur3F;
import java.nio.ByteBuffer;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class SignedHash
implements LongUnaryOperator {
    private ThreadLocal<State> state_TL = ThreadLocal.withInitial(() -> new State());

    @Override
    public long applyAsLong(long value) {
        State state = this.state_TL.get();
        state.murmur3F.reset();
        state.bb.putLong(0, value);
        state.murmur3F.update(state.bb.array(), 0, 8);
        long result = state.murmur3F.getValue();
        return result;
    }

    private static class State {
        public ByteBuffer bb = ByteBuffer.allocate(8);
        public Murmur3F murmur3F = new Murmur3F();

        private State() {
        }
    }
}

