/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_object;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataFunctions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_double.HashedDoubleRange;
import java.util.function.Function;
import java.util.function.LongFunction;

@Categories(value={Category.distributions})
@ThreadSafeMapper
public class CoinFunc
implements Function<Long, Object> {
    private final double threshold;
    private final LongFunction first;
    private final LongFunction second;
    private final HashedDoubleRange cointoss = new HashedDoubleRange(0.0, 1.0);

    @Example(value={"CoinFunc(0.15,NumberNameToString(),Combinations('A:1:B:23'))", "use the first function 15% of the time"})
    public CoinFunc(double threshold, Object first, Object second) {
        this.threshold = threshold;
        this.first = (LongFunction)VirtDataFunctions.adapt((Object)first, LongFunction.class, Object.class, (boolean)true);
        this.second = (LongFunction)VirtDataFunctions.adapt((Object)second, LongFunction.class, Object.class, (boolean)true);
    }

    @Override
    public Object apply(Long aLong) {
        double unfaircoin = this.cointoss.applyAsDouble(aLong);
        Object result = unfaircoin < this.threshold ? this.first.apply(aLong) : this.second.apply(aLong);
        return result;
    }
}

