/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class AlphaNumericString
implements LongFunction<String> {
    private static final String AVAILABLE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final ThreadLocal<StringBuilder> threadStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
    private final Hash hash = new Hash();
    private final LongToIntFunction lengthFunc;

    @Examples(value={@Example(value={"AlphaNumericString(16)", "Create an alpha numeric String with length of 16"}), @Example(value={"AlphaNumericString(HashRange(10, 14))", "Create an alpha numeric String with length variable limit (10 to 14)"})})
    public AlphaNumericString(int length) {
        this.lengthFunc = s -> length;
    }

    public AlphaNumericString(Object lengthFunc) {
        if (lengthFunc instanceof Number) {
            int size = ((Number)lengthFunc).intValue();
            this.lengthFunc = s -> size;
        } else {
            this.lengthFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)lengthFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
    }

    @Override
    public String apply(long operand) {
        int length = this.lengthFunc.applyAsInt(operand);
        long hashValue = operand;
        StringBuilder sb = this.threadStringBuilder.get();
        sb.setLength(0);
        for (int i = 0; i < length; ++i) {
            hashValue = this.hash.applyAsLong(hashValue);
            int randomPos = (int)(hashValue % (long)AVAILABLE_CHARS.length());
            sb.append(AVAILABLE_CHARS.charAt(randomPos));
        }
        return sb.toString();
    }

    public String toString() {
        return "AlphaNumericString(length=" + this.lengthFunc.applyAsInt(0L) + ")";
    }
}

