/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import io.nosqlbench.virtdata.library.basics.shared.util.CharsetMapping;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class CharBufImage
implements LongFunction<CharBuffer> {
    private final io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.Hash posFunc = new io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.Hash();
    private final CharBuffer image;
    private final int imgsize;
    private final LongToIntFunction sizefunc;

    public CharBufImage(int size) {
        this("a-zA-Z0-9 ", size, size);
    }

    public CharBufImage(Object charsFunc, int imgsize) {
        this(charsFunc, imgsize, imgsize);
    }

    public CharBufImage(Object charsFunc, int imgsize, Object sizespec) {
        this(charsFunc, imgsize, sizespec, 0L);
    }

    public CharBufImage(Object charsFunc, int imgsize, Object sizespec, long seed) {
        this.imgsize = imgsize;
        LongFunction imgfunc = null;
        if (charsFunc instanceof Number) {
            throw new BasicError("The " + this.getClass().getSimpleName() + " function has an explicit size parameter. The first parameter must be a function or string");
        }
        if (charsFunc instanceof CharSequence) {
            String chars = ((CharSequence)charsFunc).toString();
            imgfunc = l -> this.genBuf(chars, 1024, l);
        } else {
            imgfunc = (LongFunction)VirtDataConversions.adaptFunction((Object)charsFunc, LongFunction.class, (Class[])new Class[]{Object.class});
        }
        this.image = this.fill(imgfunc, imgsize, seed);
        if (sizespec instanceof Number) {
            int size = ((Number)sizespec).intValue();
            this.sizefunc = n -> size;
        } else {
            this.sizefunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizespec, LongToIntFunction.class, (Class[])new Class[0]);
        }
    }

    private CharBuffer fill(LongFunction<Object> func, int size, long seed) {
        CharBuffer cb = CharBuffer.allocate(size);
        CharBuffer src = CharBuffer.wrap(func.apply(seed++).toString());
        while (cb.hasRemaining()) {
            if (!src.hasRemaining()) {
                src = CharBuffer.wrap(func.apply(seed++).toString());
            }
            int tosend = Math.min(src.remaining(), cb.remaining());
            src.limit(tosend);
            cb.put(src);
        }
        return cb.flip().asReadOnlyBuffer();
    }

    private CharBuffer genBuf(String chars, int size, long seed) {
        char[] charset = CharsetMapping.rangeFor(chars);
        CharBuffer newimage = CharBuffer.allocate(size);
        Hash genhash = new Hash();
        while (newimage.hasRemaining()) {
            seed = genhash.applyAsLong(seed);
            int selector = (int)(seed % (long)charset.length);
            newimage.put(charset[selector]);
        }
        return newimage.flip().asReadOnlyBuffer();
    }

    @Override
    public CharBuffer apply(long value) {
        int size = Math.min(this.sizefunc.applyAsInt(value), this.imgsize);
        int pos = this.posFunc.applyAsInt(value);
        return this.image.subSequence(pos %= this.imgsize - size + 1, pos + size);
    }
}

