/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class, selector="io.nosqlbench.virtdata.library.basics.shared.from_long.to_string.CharBufImage")
public class CharBufImageAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "CharBufImage";
    }

    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_string";
    }

    public String getClassJavadoc() {
        return "Builds a shared text image in memory and samples from it\npseudo-randomly with hashing.\n\nThe characters provided can be listed like a string (abc123),\nor can include range specifiers like a hyphen (a-zA-Z0-9).\n\nThese characters are used to build an image of the specified size in\nmemory that is sampled from according to the size function.\n\nThe extracted value is sized according to either a provided function, a\nsize range, or otherwise the whole image.\n\nThe image can be varied between tests if you want by specifying a seed\nvalue. If no seed value is specified, then the image length is used\nalso as a seed.\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.nio.CharBuffer";
    }

    public Category[] getCategories() {
        return new Category[]{Category.general};
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("CharBufImage", "Shortcut constructor for building a simple text image\nfrom A-Z, a-z, 0-9 and a space, of the specified size.\nWhen this function is used, it always returns the full image\nif constructed in this way.\n@param size length in characters of the image.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("size", "int");
                    }
                }, (List)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("CharBufImage", "This is the same as {@link CharBufImage(Object,int,Object)} except that the\nextracted sample length is fixed to the buffer size, thus the function will\nalways return the full buffer.\n@param charsFunc The function which produces objects, which toString() is used to collect their input\n@param imgsize The size of the CharBuffer to build at startup\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("charsFunc", "java.lang.Object");
                        this.put("imgsize", "int");
                    }
                }, (List)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("CharBufImage", "This is the same as {@link CharBufImage(Object, int, Object, long)} excep that\nthe seed is defaulted to 0L\n@param charsFunc The function which produces objects, which toString() is used to collect their input\n@param imgsize The size of the CharBuffer to build at startup\n@param sizespec The specifier for how long samples should be. If this is a number, then it is static. If\n                it is a function, then the size is determined for each call.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("charsFunc", "java.lang.Object");
                        this.put("imgsize", "int");
                        this.put("sizespec", "java.lang.Object");
                    }
                }, (List)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("CharBufImage", "Create a CharBuffer full of the contents of the results of calling a source\nfunction until it is full. Then allow it to be sampled with random extracts\nas determined by the sizespec.\n@param charsFunc The function which produces objects, which toString() is used to collect their input\n@param imgsize The size of the CharBuffer to build at startup\n@param sizespec The specifier for how long samples should be. If this is a number, then it is static. If\n                it is a function, then the size is determined for each call.\n@param seed      A seed that can be used to change up the rendered content.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("charsFunc", "java.lang.Object");
                        this.put("imgsize", "int");
                        this.put("sizespec", "java.lang.Object");
                        this.put("seed", "long");
                    }
                }, (List)new ArrayList<List<String>>(){}));
            }
        };
    }
}

