/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.general})
public class DirectoryLines
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(DirectoryLines.class);
    private final Pattern namePattern;
    private final String basepath;
    private final List<Path> allFiles;
    private Iterator<String> stringIterator;
    private Iterator<Path> pathIterator;

    @Example(value={"DirectoryLines('/var/tmp/bardata', '.*')", "load every line from every file in /var/tmp/bardata"})
    public DirectoryLines(String basepath, String namePattern) {
        this.basepath = basepath;
        this.namePattern = Pattern.compile(namePattern);
        this.allFiles = this.getAllFiles();
        if (this.allFiles.size() == 0) {
            throw new RuntimeException("Loaded zero files from " + basepath + ", full path:" + Paths.get(basepath, new String[0]).getFileName());
        }
        this.pathIterator = this.allFiles.iterator();
        try {
            this.stringIterator = Files.readAllLines(this.pathIterator.next()).iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized String apply(long value) {
        while (!this.stringIterator.hasNext()) {
            if (this.pathIterator.hasNext()) {
                Path nextPath = this.pathIterator.next();
                try {
                    this.stringIterator = Files.readAllLines(nextPath).iterator();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            logger.debug("Resetting path iterator after exhausting input.");
            this.pathIterator = this.allFiles.iterator();
        }
        return this.stringIterator.next();
    }

    private List<Path> getAllFiles() {
        logger.debug("Loading file paths from " + this.basepath);
        HashSet<FileVisitOption> options = new HashSet<FileVisitOption>();
        options.add(FileVisitOption.FOLLOW_LINKS);
        FileList fileList = new FileList(this.namePattern);
        try {
            Files.walkFileTree(Paths.get(this.basepath, new String[0]), options, 10, fileList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("File reader: " + fileList + " in path: " + Paths.get(this.basepath, new String[0]).getFileName());
        fileList.paths.sort(Path::compareTo);
        return fileList.paths;
    }

    private static class FileList
    implements FileVisitor<Path> {
        public final Pattern namePattern;
        public int seen;
        public int kept;
        public List<Path> paths = new ArrayList<Path>();

        private FileList(Pattern namePattern) {
            this.namePattern = namePattern;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            ++this.seen;
            if (file.toString().matches(this.namePattern.pattern())) {
                this.paths.add(file);
                ++this.kept;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            logger.warn("Error traversing file: " + file + ":" + exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public String toString() {
            return this.kept + "/" + this.seen + " files with pattern '" + this.namePattern + "'";
        }
    }
}

