/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongFunction;
import uk.ydubey.formatter.numtoword.NumberInWordsFormatter;

@ThreadSafeMapper
@Categories(value={Category.general, Category.premade})
public class NumberNameToString
implements LongFunction<String> {
    private static final ThreadLocal<StringBuilder> tlsb = ThreadLocal.withInitial(StringBuilder::new);
    private static final String THOUSAND = "thousand";
    private static final String MILLION = "million";
    private static final String BILLION = "billion";
    private static final String TRILLION = "trillion";
    private static final String QUADRILLION = "quadrillion";
    private static final String QUINTILLION = "quintillion";
    private final NumberInWordsFormatter formatter = NumberInWordsFormatter.getInstance();

    @Override
    public String apply(long input) {
        long higher;
        if (input == 0L) {
            return "zero";
        }
        if (input > 0L && input <= 999999999L) {
            return this.formatter.format((int)input);
        }
        if (input < 0L && input >= -999999999L) {
            return "negative " + this.formatter.format((int)(-input));
        }
        StringBuilder sb = tlsb.get();
        sb.setLength(0);
        long value = input;
        if (value < 0L) {
            value = -value;
            sb.append("negative");
        }
        if ((higher = value / 1000000000L) > 1000000000L) {
            long evenhigher = higher / 1000000000L;
            sb.append(this.formatter.format((int)evenhigher)).append(" quintillion");
            higher %= 1000000000L;
        }
        String val = this.formatter.format((int)higher).replaceAll(THOUSAND, TRILLION).replaceAll(MILLION, QUADRILLION).replaceAll(BILLION, QUINTILLION);
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(val).append(" billion");
        String rstr = this.formatter.format((int)(input % 1000000000L));
        if (!rstr.isEmpty()) {
            sb.append(" ").append(rstr);
        }
        return sb.toString();
    }
}

