/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.general})
public class Template
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(Template.class);
    private static final String EXPR_BEGIN = "[[";
    private static final String EXPR_END = "]]";
    private final String rawTemplate;
    private LongUnaryOperator iterOp;
    private String[] literals;
    private List<LongFunction> functions;

    @Example(value={"Template('{}-{}',Add(10),Hash())", "concatenate input+10, '-', and a pseudo-random long"})
    public Template(String template, Object ... funcs) {
        this(true, template, funcs);
    }

    @Example(value={"Template(true, '{}-{}', Add(10),Hash())", "throws an error, as the Add(10) function causes a narrowing conversion for a long input"})
    public Template(boolean truncate, String template, Object ... funcs) {
        this.functions = this.functions = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
        this.rawTemplate = template;
        this.literals = this.parseTemplate(template, funcs.length);
    }

    private LongFunction<?>[] adapt(Object[] funcs) {
        LongFunction[] aryFuncs = new LongFunction[funcs.length];
        for (int i = 0; i < funcs.length; ++i) {
            aryFuncs[i] = (LongFunction)VirtDataConversions.adaptFunction((Object)funcs[i], LongFunction.class, (Class[])new Class[]{Object.class});
        }
        return aryFuncs;
    }

    public Template(LongUnaryOperator iterOp, String template, LongFunction<?> ... funcs) {
        this(template, funcs);
        this.iterOp = iterOp;
    }

    private String[] parseTemplate(String template, int funcCount) {
        try {
            ArrayList<String> literals = new ArrayList<String>();
            Pattern p = Pattern.compile("\\{}");
            Matcher m = p.matcher(template);
            int pos = 0;
            while (m.find()) {
                literals.add(template.substring(pos, m.start()));
                pos = m.end();
            }
            String partial = template.substring(pos);
            literals.add(partial);
            if (literals.size() != funcCount + 1) {
                throw new RuntimeException("The number of {} place holders in '" + template + "' should equal the number of functions.");
            }
            return literals.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String apply(long value) {
        StringBuilder buffer = new StringBuilder();
        buffer.setLength(0);
        buffer.append(this.literals[0]);
        if (this.literals.length > 1) {
            for (int i = 0; i < this.functions.size(); ++i) {
                long input = this.iterOp != null ? this.iterOp.applyAsLong(value + (long)i) : value + (long)i;
                String genString = String.valueOf(this.functions.get(i).apply(input));
                buffer.append(genString);
                buffer.append(this.literals[i + 1]);
            }
        }
        return buffer.toString();
    }
}

