/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.Date;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class ToDate
implements LongFunction<Date> {
    private final long spacing;
    private final long repeat_count;

    @Example(value={"ToDate(86400000,2)", "produce two Date values per day"})
    public ToDate(int millis_multiplier, int millis_divisor) {
        this.spacing = millis_multiplier;
        this.repeat_count = millis_divisor;
    }

    @Example(value={"ToDate(86400000)", "produce a single Date() per day"})
    public ToDate(int spacing) {
        this(spacing, 1);
    }

    public ToDate() {
        this.spacing = 1L;
        this.repeat_count = 1L;
    }

    @Override
    public Date apply(long input) {
        input = input * this.spacing / this.repeat_count;
        return new Date(input);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.spacing + ":" + this.repeat_count;
    }
}

