/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@ThreadSafeMapper
@DeprecatedFunction(value="This will be replaced by the more aptly named toJodaDateTime(...)")
@Categories(value={Category.datetime})
public class ToDateTime
implements LongFunction<DateTime> {
    private long spacing;
    private long repeat_count;

    public ToDateTime(int spacing, int repeat_count) {
        this.spacing = spacing;
        this.repeat_count = repeat_count;
    }

    public ToDateTime(String spacing) {
        this(Integer.valueOf(spacing), 1);
    }

    public ToDateTime() {
        this.spacing = 1L;
        this.repeat_count = 1L;
    }

    @Override
    public DateTime apply(long input) {
        input = input * this.spacing / this.repeat_count;
        return new DateTime(input, DateTimeZone.UTC);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.spacing + ":" + this.repeat_count;
    }
}

