/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types.joda;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_time_types.joda.Timezones;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfNamedWeekDay
implements LongUnaryOperator {
    private final DateTimeZone tz;
    private final int weekdayReference;

    @Example(value={"ToMillisAtStartOfNamedWeekDay()", "return millisecond epoch time of the start of the most recent Monday (possibly the day-of) of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfNamedWeekDay() {
        this("Monday");
    }

    @Example(value={"ToMillisAtStartOfNamedWeekDay('Wednesday')", "return millisecond epoch time of the start of the most recent Wednesday (possibly the day-of) of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfNamedWeekDay(String weekday) {
        this(weekday, DateTimeZone.UTC.getID());
    }

    @Example(value={"ToMillisAtStartOfNamedWeekDay('Saturday','America/Chicago'')", "return millisecond epoch time of the start of the most recent Saturday (possibly the day-of) of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfNamedWeekDay(String weekday, String timezoneId) {
        this.weekdayReference = WeekDays.valueOfOrdinal(weekday);
        this.tz = Timezones.forId(timezoneId);
    }

    @Override
    public long applyAsLong(long operand) {
        DateTime ref = new DateTime(operand, this.tz).withTimeAtStartOfDay();
        DateTime dateTime = ref.withDayOfWeek(this.weekdayReference);
        return dateTime.isBefore((ReadableInstant)ref) ? dateTime.getMillis() : dateTime.plusDays(7).getMillis();
    }

    private static enum WeekDays {
        Monday(1),
        Tuesday(2),
        Wednesday(3),
        Thursday(4),
        Friday(5),
        Saturday(6),
        Sunday(7);

        private final int ordinal;

        private WeekDays(int jodaOrdinal) {
            this.ordinal = jodaOrdinal;
        }

        public static int valueOfOrdinal(String weekdayName) {
            for (WeekDays value : WeekDays.values()) {
                if (!value.toString().toLowerCase().equals(weekdayName.toLowerCase())) continue;
                return value.ordinal;
            }
            throw new RuntimeException("Unable to map weekday name " + weekdayName + " to values: " + Arrays.toString((Object[])WeekDays.values()));
        }
    }
}

