/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.nondeterministic.to_int;

import io.nosqlbench.nb.api.metadata.Indexed;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
@Categories(value={Category.state})
public class ThreadNum
implements LongToIntFunction {
    private static final Pattern pattern = Pattern.compile("^.*?(\\d+).*$");
    private final ThreadLocal<Integer> threadLocalInt = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            if (Thread.currentThread() instanceof Indexed) {
                return ((Indexed)Thread.currentThread()).getIndex();
            }
            Matcher matcher = pattern.matcher(Thread.currentThread().getName());
            if (matcher.matches()) {
                return Integer.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unable to match a digit sequence in thread name:" + Thread.currentThread().getName());
        }
    };

    @Override
    public int applyAsInt(long value) {
        return this.threadLocalInt.get();
    }
}

