/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadInteger
implements Function<Object, Integer> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final int defaultValue;

    @Example(value={"LoadInteger('foo')", "for the current thread, load an integer value from the named variable."})
    public LoadInteger(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger('foo',42)", "for the current thread, load an integer value from the named variable, or the default value if the named variable is not defined."})
    public LoadInteger(String name, int defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadInteger(NumberNameToString())", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function."})
    public LoadInteger(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger(NumberNameToString(),42)", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadInteger(Function<Object, Object> nameFunc, int defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public Integer apply(Object o) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(o)) : this.name;
        Object value = map.getOrDefault(varname, this.defaultValue);
        return (Integer)value;
    }
}

