/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadLong
implements Function<Object, Long> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private long defaultValue;

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable."})
    public LoadLong(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable, or the default value if the named variable is not defined."})
    public LoadLong(String name, long defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function."})
    public LoadLong(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadLong(Function<Object, Object> nameFunc, long defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public Long apply(Object o) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(o)) : this.name;
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        Object value = map.getOrDefault(varname, this.defaultValue);
        return (Long)value;
    }
}

