/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.statistics;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataFunctions;
import java.util.DoubleSummaryStatistics;
import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.statistics})
public class LongStats
implements DoubleUnaryOperator {
    DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
    DoubleSupplier accessor;
    DoubleUnaryOperator valueFunc;

    public LongStats(String spec) {
        this(spec, v -> v, true);
    }

    public LongStats(String spec, Object func, boolean truncate) {
        switch (spec.toLowerCase(Locale.ROOT)) {
            case "min": {
                this.accessor = this.stats::getMin;
                break;
            }
            case "max": {
                this.accessor = this.stats::getMax;
                break;
            }
            case "average": 
            case "avg": {
                this.accessor = this.stats::getAverage;
                break;
            }
            case "count": {
                this.accessor = this.stats::getCount;
                break;
            }
            case "sum": {
                this.accessor = this.stats::getSum;
                break;
            }
            default: {
                throw new RuntimeException("You must specify one of min,max,avg,count,sum");
            }
        }
        this.valueFunc = (DoubleUnaryOperator)VirtDataFunctions.adapt((Object)func, DoubleUnaryOperator.class, Double.TYPE, (boolean)truncate);
    }

    @Override
    public double applyAsDouble(double operand) {
        this.stats.accept(this.valueFunc.applyAsDouble(operand));
        return this.accessor.getAsDouble();
    }
}

