/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_int;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.unary_int.Hash;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class HashInterval
implements IntUnaryOperator {
    private final int minValue;
    private final int width;
    private final Hash hash = new Hash();

    @Example(value={"HashInterval(4)", "return values which could include 0, 1, 2, 3, but not 4"})
    public HashInterval(int width) {
        this.minValue = 0;
        this.width = width;
    }

    @Example(value={"HashInterval(2,5)", "return values which could include 2, 3, 4, but not 5"})
    public HashInterval(int minIncl, int maxExcl) {
        if (maxExcl <= minIncl) {
            throw new BasicError("HashInterval must have min and max value in that order, where the min is less than the max.");
        }
        this.minValue = minIncl;
        this.width = maxExcl - minIncl;
    }

    @Override
    public int applyAsInt(int operand) {
        return this.minValue + (this.hash.applyAsInt(operand) & this.width);
    }
}

