/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_int;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.unary_int.Hash;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class HashRange
implements IntUnaryOperator {
    private final int minValue;
    private final int width;
    private final Hash hash = new Hash();

    public HashRange(int width) {
        this.minValue = 0;
        this.width = width;
    }

    public HashRange(int minValue, int maxValue) {
        if (maxValue < minValue) {
            throw new BasicError("HashRange must have min and max value in that order.");
        }
        this.minValue = minValue;
        this.width = maxValue - minValue + 1;
    }

    @Override
    public int applyAsInt(int operand) {
        return this.minValue + (this.hash.applyAsInt(operand) & this.width);
    }
}

