/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class URLEncode
implements Function<String, String> {
    private final Charset charset;

    @Example(value={"URLEncode('UTF-16')", "URLEncode using the UTF-16 charset."})
    public URLEncode(String charset) {
        this.charset = Charset.forName(charset);
    }

    @Example(value={"URLEncode()", "URLEncode using the default UTF-8 charset."})
    public URLEncode() {
        this.charset = StandardCharsets.UTF_8;
    }

    @Override
    public String apply(String s) {
        return URLEncoder.encode(s, this.charset);
    }
}

