/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CharsetMapping {
    public static char[][] parseSpec(String spec) {
        String[] ranges = spec.split("[,;]");
        char[][] cs = new char[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            char[] range = CharsetMapping.rangeFor(ranges[i]);
            cs[i] = range;
        }
        return cs;
    }

    public static char[] rangeFor(String range) {
        ArrayList<Character> chars = new ArrayList<Character>();
        int pos = 0;
        while (pos < range.length()) {
            if (range.length() > pos + 2 && range.charAt(pos + 1) == '-') {
                List<Character> rangeChars = CharsetMapping.rangeFor(range.substring(pos, pos + 1), range.substring(pos + 2, pos + 3));
                chars.addAll(rangeChars);
                pos += 3;
                continue;
            }
            chars.add(Character.valueOf(range.substring(pos, pos + 1).charAt(0)));
            ++pos;
        }
        char[] charAry = new char[chars.size()];
        for (int i = 0; i < chars.size(); ++i) {
            charAry[i] = ((Character)chars.get(i)).charValue();
        }
        return charAry;
    }

    public static List<Character> rangeFor(String startChar, String endChar) {
        int start = startChar.getBytes(StandardCharsets.US_ASCII)[0];
        byte end = endChar.getBytes(StandardCharsets.US_ASCII)[0];
        CharsetMapping.assertPrintable(start);
        CharsetMapping.assertPrintable(end);
        CharsetMapping.assertOrder(start, end);
        ArrayList<Character> chars = new ArrayList<Character>();
        ByteBuffer bb = ByteBuffer.allocate(1);
        for (int i = start; i <= end; ++i) {
            bb.clear();
            bb.put(0, (byte)i);
            CharBuffer decoded = StandardCharsets.US_ASCII.decode(bb);
            chars.add(Character.valueOf(decoded.get(0)));
        }
        return chars;
    }

    private static void assertOrder(int start, int end) {
        if (end < start) {
            throw new RuntimeException("char '" + (char)end + "' (" + end + ") occurs after '" + (char)start + "' (" + start + "). Are you sure this is the right spec? (reverse the order)");
        }
    }

    private static void assertPrintable(int asciiCode) {
        if (asciiCode > 126 || asciiCode < 32) {
            throw new RuntimeException("ASCII character for code " + asciiCode + " is outside the range of printable characters.");
        }
    }
}

