/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.common;

import io.nosqlbench.virtdata.library.basics.shared.unary_int.Hash;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public class InterpolatingIntDoubleSampler
implements IntToDoubleFunction {
    private final double[] lut;
    private final DoubleUnaryOperator f;
    private final boolean clamp;
    private final double clampMin;
    private final double clampMax;
    private final double scaleToIntRanged;
    private Hash hash;

    public InterpolatingIntDoubleSampler(DoubleUnaryOperator icdSource, int resolution, boolean hash, boolean clamp, double clampMin, double clampMax, boolean finite) {
        this.f = icdSource;
        this.clamp = clamp;
        this.clampMin = clampMin;
        this.clampMax = clampMax;
        if (hash) {
            this.hash = new Hash();
        }
        double[] computed = this.precompute(resolution);
        if (finite) {
            while (computed.length > 0 && Double.isInfinite(computed[0])) {
                computed = Arrays.copyOfRange(computed, 1, computed.length - 1);
            }
            while (computed.length > 0 && Double.isInfinite(computed[computed.length - 1])) {
                computed = Arrays.copyOfRange(computed, 0, computed.length - 2);
            }
        }
        double[] padded = new double[computed.length + 1];
        System.arraycopy(computed, 0, padded, 0, computed.length);
        this.scaleToIntRanged = 4.656612875245797E-10 * (double)(padded.length - 2);
        this.lut = padded;
    }

    private double[] precompute(int resolution) {
        double[] precomputed = new double[resolution];
        for (int s = 0; s < resolution; ++s) {
            double rangedToUnit = (double)s / (double)resolution;
            double sampleValue = this.f.applyAsDouble(rangedToUnit);
            precomputed[s] = sampleValue = this.clamp ? Double.max(this.clampMin, Double.min(this.clampMax, sampleValue)) : sampleValue;
        }
        return precomputed;
    }

    @Override
    public double applyAsDouble(int input) {
        if (this.hash != null) {
            input = this.hash.applyAsInt(input);
        }
        double samplePoint = this.scaleToIntRanged * (double)input;
        int leftidx = (int)samplePoint;
        double fractional = samplePoint - (double)leftidx;
        double sample = this.lut[leftidx] * (1.0 - fractional) + this.lut[leftidx + 1] * fractional;
        return sample;
    }
}

