/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.curves4.continuous.common;

import io.nosqlbench.virtdata.library.curves4.discrete.common.ThreadSafeHash;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;

public class InterpolatingLongDoubleSampler
implements LongToDoubleFunction {
    private static final double MAX_LONG_AS_DOUBLE = 9.223372036854776E18;
    private final double[] lut;
    private final DoubleUnaryOperator f;
    private final boolean clamp;
    private final double clampMin;
    private final double clampMax;
    private final double scaleToLong;
    private ThreadSafeHash hash;

    public InterpolatingLongDoubleSampler(DoubleUnaryOperator icdSource, int resolution, boolean hash, boolean clamp, double clampMin, double clampMax, boolean finite) {
        this.f = icdSource;
        if (hash) {
            this.hash = new ThreadSafeHash();
        }
        this.clamp = clamp;
        this.clampMin = clampMin;
        this.clampMax = clampMax;
        double[] computed = this.precompute(resolution);
        if (finite) {
            while (computed.length > 0 && Double.isInfinite(computed[0])) {
                computed = Arrays.copyOfRange(computed, 1, computed.length - 1);
            }
            while (computed.length > 0 && Double.isInfinite(computed[computed.length - 1])) {
                computed = Arrays.copyOfRange(computed, 0, computed.length - 2);
            }
        }
        double[] padded = new double[computed.length + 1];
        System.arraycopy(computed, 0, padded, 0, computed.length);
        this.scaleToLong = 1.0842021724855044E-19 * (double)(padded.length - 2);
        this.lut = padded;
    }

    private double[] precompute(int resolution) {
        double[] precomputed = new double[resolution];
        for (int s = 0; s < resolution; ++s) {
            double rangedToUnit = (double)s / (double)resolution;
            double sampleValue = this.f.applyAsDouble(rangedToUnit);
            precomputed[s] = sampleValue = this.clamp ? Double.max(this.clampMin, Double.min(this.clampMax, sampleValue)) : sampleValue;
        }
        return precomputed;
    }

    @Override
    public double applyAsDouble(long input) {
        if (this.hash != null) {
            input = this.hash.applyAsLong(input);
        }
        double samplePoint = this.scaleToLong * (double)input;
        int leftidx = (int)samplePoint;
        double fractional = samplePoint - (double)leftidx;
        double sample = this.lut[leftidx] * (1.0 - fractional) + this.lut[leftidx + 1] * fractional;
        return sample;
    }
}

